///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthProcessCommand(char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;

    char FlaggedData[MaxReceiveSize + 1];
	char SendTemp[MaxReceiveSize + 1];

    if( strcmp(ReceivedData, "::Authentication.Success") == 0)
    {
        return AUTH_CMD_SUCCESS;
    }
    else if( strcmp(ReceivedData, "::Authentication") == 0)
    {
        sprintf(SendTemp, "::Authentication:%s", gsAuthString);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqCompanyName") == 0)
    {
        sprintf(SendTemp, "::CompanyName:%s", gsCompanyName);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqCompanyPassword") == 0)
    {
        sprintf(SendTemp, "::CompanyPassword:%s", gsCompanyPassword);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::ReqClientVersion") == 0)
    {
        sprintf(SendTemp, "::ClientVersion:%s", FileVersion);
        SimpleClientSend(SendTemp);
        return AUTH_CMD_OK;
    }
    else if( strcmp(ReceivedData, "::Disconnect") == 0)
    {
        return AUTH_CMD_DISCONNECT;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Error:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        WriteLog(FlaggedData);

        return AUTH_CMD_DISCONNECT;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Message:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        WriteLog(FlaggedData);

        return AUTH_CMD_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::AutoUpdate:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        WriteLog("Starting automatic update process.");

        char OldExe[256];
        char NewExe[256];

        sprintf(OldExe, "%s\\%s", gsPath, "AutoUpdate.Exe");
        sprintf(NewExe, "%s\\%s", Get_TempDirectory(), "SQLEUpdate.Exe");

        CopyFile(OldExe, NewExe, FALSE);
        ShellExecute(MainDialog_hWnd, "Open", NewExe, FlaggedData, Get_CurrentDirectory(), SW_SHOWNORMAL);
        xCommandService(SERVICE_CONTROL_STOP);

        return AUTH_CMD_DISCONNECT;
    }

    return AUTH_CMD_UNKNOWN;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthenticateWithServer(void)
{
    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    while(MyClient.Connected)
    {
        if(MyClient.GetReceiveData(ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int AuthCmdResult = AuthProcessCommand(ReceiveData, ReceiveSize);
            if(AuthCmdResult == AUTH_CMD_FAILED)
            {
//                WriteLog("AUTH_CMD_FAILED");
                return AUTH_CMD_FAILED;
            }
            else if(AuthCmdResult == AUTH_CMD_SUCCESS){
//                WriteLog("AUTH_CMD_SUCCESS");
                return AUTH_CMD_SUCCESS;
            }
            else if(AuthCmdResult == AUTH_CMD_DISCONNECT){
//                WriteLog("AUTH_CMD_DISCONNECT");
                return AUTH_CMD_DISCONNECT;
            }
            else if(AuthCmdResult == AUTH_CMD_UNKNOWN){
//                WriteLog("AUTH_CMD_UNKNOWN");
                return AUTH_CMD_UNKNOWN;
            }
            else if(AuthCmdResult == AUTH_CMD_OK){
//                WriteLog("AUTH_CMD_OK");
                // Still authenticating
            }
        }
        else Sleep(1);

        Sleep(1);
    }

//    WriteLog("AUTH_CMD_DISCONNECT ERR");
    return AUTH_CMD_DISCONNECT;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

